// graymonitor.c

#include "main.h"
#include "graymonitor.h"
#include "grays.h"
#include "score.h"
#include "wdef.h"
#include "gworld.h"
#include "graphics.h"
#include "level.h"

Rect grayMonitorZRect, grayMonitorRect[2];
Boolean grayMonitorVisible[2] = {true, true};
GWorldPtr smallGrayDrawWorld;

void InitGrayMonitors( void )
{
	const double windowLoc[ ] = { 0.16, 0.84 };
		 
	grayMonitorZRect.top = grayMonitorZRect.left = 0;
	grayMonitorZRect.bottom = 32; grayMonitorZRect.right = 144;
	
	grayMonitorRect[0] = grayMonitorRect[1] = grayMonitorZRect;
	CenterRectInPort( &grayMonitorRect[0], backdropPort, windowLoc[0], 0.11 );
	CenterRectInPort( &grayMonitorRect[1], backdropPort, windowLoc[1], 0.11 );

	InitGWorld( &smallGrayDrawWorld, &grayMonitorZRect, 16 );
	DrawPictInGWorld( smallGrayDrawWorld, picBoard );
}

void ShowGrayMonitor( short player )
{
	short monitor;
	int smallGrayList[] = 
	{
		0, kSmallGray1, kSmallGray2, kSmallGray3, kSmallGray4, kSmallGray5
	};
	
	Rect myRect = { 4, 4, kBlobVertSize+4, 4 }, 
		 srcRect;

	if( !grayMonitorVisible[player] ) return;
	
	if( control[player] == kNobodyControl )
	{
	}
	else
	{
		PrepareForGDrawing( smallGrayDrawWorld );
		
		CopyBits( GetPortBitMapForCopyBits(smallBoardWorld[player]), GetPortBitMapForCopyBits(smallGrayDrawWorld),
	  				&grayMonitorZRect, &grayMonitorZRect, srcCopy, nil );
	 				
		monitor = unallocatedGrays[player];
		
		CalcBlobRect( kSobBlob, 3, &srcRect );
		while( monitor >= (6*4) )
		{
			myRect.right += kBlobHorizSize;
			DrawSprite( &myRect, 4, kSobBlob );
			myRect.left = myRect.right;
			
			monitor -= (6*4);
		}
		
		CalcBlobRect( kNoSuction, kGray-1, &srcRect );
		while( monitor >= 6 )
		{
			myRect.right += kBlobHorizSize;
			DrawAlpha( &myRect, kGray, kLight, kGrayNoBlink );
			myRect.left = myRect.right;
			
			monitor -= 6;
		}
		
		if( monitor > 0 )
		{
			myRect.right += kBlobHorizSize;
			DrawAlpha( &myRect, kGray, kLight, smallGrayList[monitor] );
			myRect.left = myRect.right;
			myRect.right += kBlobHorizSize;
			DrawAlpha( &myRect, kGray, kLight, smallGrayList[monitor]+1 );
		}
		
		FinishGDrawing( smallGrayDrawWorld );

		SetPort( backdropPort );
		CopyBits( GetPortBitMapForCopyBits(smallGrayDrawWorld), GetPortBitMapForCopyBits( backdropPort ),
		  				&grayMonitorZRect, &grayMonitorRect[player], srcCopy, nil );
	}
}